<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Surgery;
use DB;
use Auth;

class SurgeryController extends Controller
{
    public function index()
    {
        $title =  'Surgery';
        $heading =  'Surgery';

        if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage Settings') == 0) {
            return back();
        }

        $data = Surgery::orderBy('id', 'DESC')->get();
        return view('admin.surgery.index', compact('title', 'heading', 'data'));
    }
    public function add()
    {
        $title =  'Surgery Create';
        $heading =  'Surgery Create';

        if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage Settings') == 0) {
            return back();
        }
        return view('admin.surgery.add', compact('title', 'heading'));
    }
    public function addSurgery(Request $request)
    {

        $request->validate([
            'surgery' => 'required|unique:surgeries,surgery'

        ]);

        $surgery =  new Surgery;
        $surgery->surgery = $request->surgery;
        $surgery->status = 1;
        $surgery->save();
        return redirect()->route('admin.surgeries')->with('message', 'Surgery added successfully');
    }
    public function status_update($id, $status)
    {
        $surgery =  Surgery::find($id);
        $surgery->status = $status;
        $surgery->save();
        return redirect()->route('admin.surgeries')->with('message', 'Surgery updated successfully');
    }
    public function edit($id)
    {
        $title =  'Surgery Edit';
        $heading =  'Surgery Edit';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        $data = Surgery::where('id', $id)->first();
        return view('admin.surgery.edit', compact('title', 'heading', 'data'));
    }
    public function editSurgery(Request $request)
    {
        $request->validate([
            'surgery' => 'required|unique:surgeries,surgery,' . $request->id

        ]);


        $surgery =  Surgery::find($request->id);
        $surgery->surgery = $request->surgery;

        $surgery->save();
        return redirect()->route('admin.surgeries')->with('message', 'Surgery updated successfully');
    }
    public function import()
    {
        $title =  'Surgery';
        $heading =  'Surgery';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }
        return view('admin.surgery.export', compact('title', 'heading'));
    }
    public function exportSurgery(Request $request)
    {

        $path = $request->file('csv_file')->getRealPath();

        $name = $request->file('csv_file')->getClientOriginalName();
        $p = explode('.', $name);
        if (str_contains($p[0], 'surgery')) {

            $data = array_map('str_getcsv', file($path));


            $count = count($data);
            for ($i = 1; $i < $count; $i++) {

                DB::table('surgeries')->insert([
                    'surgery' => $data[$i][0],

                    'status' => 1
                ]);
            }

            return back()->with('message', 'Surgery Uploaded Successfully');
        } else {
            return back()->with('error', 'Wrong csv uploaded please Download the sample file and upload the data !');
        }
    }
    public function delete_surgery($id)
    {
        $surgery =  Surgery::find($id);
   

        $surgery->delete();
        return redirect()->route('admin.surgeries')->with('message', 'Surgery deleted successfully');
    }
    public function delete_all()
    {
        DB::table('surgeries')->delete();
        return redirect()->route('admin.surgeries')->with('message', 'Surgery deleted successfully');
    }
}
