<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Socialhistory;
use DB;
use Auth;

class SocialhistoryController extends Controller
{
    public function index()
    {
        $title =  'Social history';
        $heading =  'Social history';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }
        $data = Socialhistory::orderBy('id', 'DESC')->get();
        return view('admin.social_history.index', compact('title', 'heading', 'data'));
    }
    public function add()
    {
        $title =  'Social history';
        $heading =  'Social history';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        } 
        return view('admin.social_history.add', compact('title', 'heading'));
    }
    public function addSocial(Request $request)
    {
        $request->validate([
            'social_history' => 'required|unique:social_history,social_history'

        ]);


        $social =  new Socialhistory;
        $social->social_history = $request->social_history;
        $social->status = 1;
        $social->save();
        return redirect()->route('admin.social_history')->with('message', 'Social History added successfully');
    }
    public function status_update($id, $status)
    {
        $social =  Socialhistory::find($id);
        $social->status = $status;
        $social->save();
        return redirect()->route('admin.social_history')->with('message', 'Social History updated successfully');
    }
    public function edit($id)
    {
        $title =  'Social history';
        $heading =  'Social history';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        $data = Socialhistory::where('id', $id)->first();
        return view('admin.social_history.edit', compact('title', 'heading', 'data'));
    }
    public function editSocial(Request $request)
    {
        $request->validate([
            'social_history' => 'required|unique:social_history,social_history,' . $request->id

        ]);


        $social =  Socialhistory::find($request->id);
        $social->social_history = $request->social_history;
        $social->save();
        return redirect()->route('admin.social_history')->with('message', 'Social History updated successfully');
    }
    public function import()
    {
        $title =  'Social History';
        $heading =  'Social History';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        return view('admin.social_history.export', compact('title', 'heading'));
    }
    public function exportSocial_history(Request $request)
    {

        $path = $request->file('csv_file')->getRealPath();
        $name = $request->file('csv_file')->getClientOriginalName();
        $p = explode('.', $name);
        if (str_contains($p[0], 'social_history')) {
            $data = array_map('str_getcsv', file($path));


            $count = count($data);
            for ($i = 1; $i < $count; $i++) {

                DB::table('social_history')->insert([
                    'social_history' => $data[$i][0],

                    'status' => 1
                ]);
            }

            return back()->with('message', 'Social History Uploaded Successfully');
        } else {
            return back()->with('error', 'Wrong csv uploaded please Download the sample file and upload the data !');
        }
    }
    public function delete_social($id)
    {
        $social =  Socialhistory::find($id);
      
        $social->delete();
        return redirect()->route('admin.social_history')->with('message', 'Social History deleted successfully');
    }
    public function delete_all()
    {
        DB::table('social_history')->delete();
        return redirect()->route('admin.social_history')->with('message', 'Social History deleted successfully');
    }
}
