<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SiteSetting;
use App\Models\UserPermission;
use App\Utility;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Auth;
use App\Models\Appointment;
use App\Models\Service;

class SiteSettingsController extends Controller
{
    public function index(Request $request)
    {

        $title = $heading =  'Site Setting List';
        $search = $request->input('search');

        $dataList = SiteSetting::select('*')
            ->when($search, function ($query) use ($search) {
                return $query->where('key', 'LIKE', "%$search%")
                    ->orWhere('value', 'LIKE', "%$search%");
            })
            ->orderBy('key', 'ASC')
            ->paginate(15);

        return view('admin.site_settings.index', compact('title', 'heading', 'dataList', 'search'));
    }
    public function  slot_time()
    {
        $title = 'Slot Time';
        $title_2 = 'Slot Time';
        $slot_time = DB::table('slot_time')->first();
        return view('admin.slot_time.form', compact('title', 'title_2', 'slot_time'));
    }
    public function slot_time_post(Request $request)
    {
        if ($request->id == '') {
            $slot_time = DB::table('slot_time')->insert([
                'slot' => $request->slot . $request->type,
                
            ]);
        } else {
            $slot_time = DB::table('slot_time')->where('id', $request->id)->update([
                'slot' => $request->slot . $request->type,
              
            ]);
        }

        return back()->with('message', 'Time Slot Updated');
    }

    // public function create()
    // {
    //     $title = 'Site Setting ';
    //     $title_2 = 'Add';
    //     return view('admin.cms.form', compact('title', 'title_2'));
    // }

    public function edit($id)
    {

        $title = 'Site Setting ';
        $title_2 = 'Edit';
        $dataRow = SiteSetting::find($id);
        return view('admin.site_settings.form', compact('title', 'title_2', 'dataRow'));
    }

    // public function view($id)
    // {
    //     $title =  'Site Setting ';
    //     $title_2 = 'Details';
    //     $dataRow = SiteSetting::find($id);

    //     return view('admin.site_settings.show', compact('title', 'title_2','dataRow'));
    // }

    public function store(Request $request)
    {
        $input = $request->all();


        $id = $request->id;


        $store = SiteSetting::find($id);
        $flag = 'updated';

        if (in_array($store->key, ['logo', 'logo_small'])) {
            if ($request->hasFile('value')) {
                $store->value = Utility::saveImage($request->file('value'), 'site_settings', $store->key);
            }
        } else {
            $store->value = $request->value;
        }

        $store->save();
        Session::flash('Success-toastr', "Site settings has been $flag successfully.");

        return redirect()->route('admin.site_settings_list');
    }
    public function  payment_status()
    {
        $title = 'Payment Mode';
        $title_2 = 'Payment Mode';
        $data = DB::table('payment_mode')->first();
        return view('admin.slot_time.payment_status', compact('title', 'title_2','data'));
    }
    public function  payment_status_post(Request $request)
    {
        if($request->id == '')
        {
            DB::table('payment_mode')->insert([
                'status'=>$request->status
            ]);
            
        }
        else{
            DB::table('payment_mode')->where('id',$request->id)->update([
                'status'=>$request->status
            ]);
           
        }


        return json_encode(1);
       
    }

    public function appointments(Request $request)
    {
        $title =  'Appointments';
        $heading =  'Appointments';

        if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Appointment') == 0) {
            return back();
        }
        if ($request->from_date > $request->to_date) {
            return back()->with('message', 'Invalid Date Range');
        }
     

        $filter =  Appointment::with('doctor', 'patient')->where('app_type','B');
        if (isset($request->from_date)) {
            $filter->whereBetween('date', [$request->from_date, $request->to_date]);
        }
        if (isset($request->spl_id)) {
            $filter->where('spl_id', $request->spl_id);
        }
        if (isset($request->con_type)) {
            $filter->where('consultation_type', $request->con_type);
        }

        $data['services'] = Service::all();
        $appointments = $filter->where('patient_id', '!=', 0)->orderBy('id', 'DESC')->get();
        $u = [];

        foreach ($appointments as $row) {
            if ($row->payment_status !== null) {
                array_push($u,$row);
            }
        }
       
        $data['appointments']=$u;




        return view('admin.appoinment.index', compact('title', 'heading'), $data);
    }

    public function appointments_view($id)
    {
        $title =  'Appointments Details';
        $heading =  'Appointments Details';
        if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Appointment') == 0) {
            return back();
        }
        $data['appointment'] = Appointment::with('doctor', 'patient', 'specialization')->where('id', $id)->first();

        return view('admin.appoinment.view', compact('title', 'heading'), $data);
    }

    public function q_appointment(Request $request)
    {
        $title =  'Appointments';
        $heading =  'Appointments';

        if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage QuickVisit') == 0) {
            return back();
        }

        if ($request->from_date > $request->to_date) {
            return back()->with('message', 'Invalid Date Range');
        }

        $filter =  Appointment::with('doctor','patient')->where('app_type','Q');
        if (isset($request->from_date)) {
            $filter->whereBetween('date', [$request->from_date, $request->to_date]);
        }

        if (isset($request->con_type)) {
            $filter->where('consultation_type', $request->con_type);
        }


        $data['appointments'] = $filter->orderBy('id', 'DESC')->get();
        return view('admin.appoinment.quick_visit', compact('title', 'heading'), $data);
    }



}
