<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Service;
use App\helpers;
use Session;
use DB;
use Auth;

class ServiceController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');

    }

    public function index(Request $request)
    {
        //$categoryArr = $this->membersModel->all();

        $title =  'Speciality List';
        $heading =  'Speciality List';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }
        $search = $request->input('search');

        $b_categories = Service::select('*')
            // ->where('is_employee',1)
            ->when($search, function ($query) use ($search) {
                return $query->where('name', 'LIKE', "%$search%");
                // ->orWhere('description', $search);
            })
            ->orderBy('id', 'DESC')
            ->get();

        return view('admin.service.index', compact('title', 'b_categories', 'heading'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        // $allCountries = DB::table('countries')->get();
        $title =  'Speciality Add';
        $heading =  'Speciality Add';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }


        $data = DB::table('treatments')->get();
        return view('admin.service.create', compact('title', 'heading', 'data'));
    }
    public function   delete($id)
    {
        $store = Service::where('id',$id)->delete();
        Session::flash('Success-toastr', 'Speciality has been deleted successfully.');
        return back()->with('msg', 'Speciality has been deleted successfully.');
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $validator = $request->validate([
            'name' => 'required',
        
        ]);

        $store = new Service;
    
        $store->name = $input['name'];

        // if ($request->hasFile('image')) {

        //     $file = $request->file('image');
        //     $imageName = $file->getClientOriginalName();
        //     $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);
        //     $image = microtime() . "." . $file_ext;
        //     $upload_image = $file->move(public_path('/uploads/food'), $image);
        //     $store->image = $image;
        // }

        $store->save();
        Session::flash('Success-toastr', 'Speciality has been inserted successfully.');

        return redirect()->route('admin.service.index')->with('alert-class', 'alert-success')->with('msg', 'Speciality has been inserted successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Members  $members
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $title =  'Speciality Details';
        $heading =  'Speciality Details';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }
        // $member = $allMembers = Members::withTrashed()->where('members.id',$id)->first();

        $store = Service::find($id);

        return view('admin.service.show', compact('title', 'heading', 'store'));
    }

    public function edit($id)
    {
        // $allCountries = DB::table('countries')->get();
        $title =  'Speciality Edit';
        $heading =  'Speciality Edit';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }
        $storeDetailsById = Service::find($id);
        return view('admin.service.edit', compact('title', 'heading', 'storeDetailsById'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Members  $members
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        //dd($input);
        $validator = $request->validate([
            'name' => 'required',
        ]);

        $store = Service::find($id);
        $store->name = $input['name'];
        $store->save();
        Session::flash('Success-toastr', 'Speciality has been updated successfully.');

        return redirect()->route('admin.service.index')->with('alert-class', 'alert-success')->with('msg', 'Speciality has been updated successfully.');
    }


    public function destroy($id)
    {
        Food::delete($id);
        return redirect()->back()->with('alert-class', 'alert-success')->with('msg', 'Food & Drinks has been deleted successfully.');
    }

    public function restore(Request $request, $id)
    {
        $member = Food::withTrashed()->find($id);
        $member->restore();
        return redirect()->back()->with('alert-class', 'alert-success')->with('msg', ' Successfully restored.');
    }

    public function active($id)
    {
        $user = Service::find($id);
        $user->status = '1';
        $user->save();
        DB::table('Service_user')->where('service_id', $id)->update(['status' => 1]);
        Session::flash('Success-toastr', 'Speciality successfully activated.');

        return redirect()->route('admin.service.index')->with('alert-class', 'alert-success')->with('msg', 'Speciality successfully activated.');;
    }

    public function inactive($id)
    {
        $user = Service::find($id);
        $user->status = 0;
        $user->save();
        DB::table('Service_user')->where('service_id', $id)->update(['status' => 0]);

        Session::flash('Success-toastr', 'Speciality successfully inctivated.');

        return redirect()->route('admin.service.index')->with('alert-class', 'alert-success')->with('msg', 'Speciality successfully inctivated.');;
    }
}
