<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\NewsLetter;
use Session;

class NewsLetterController extends Controller
{
    public function index(Request $request)
    {
    	$newsLetters = NewsLetter::when($search,function ($query) use ($search) {
            $query->where('email', 'LIKE', "%$search%");
        })->latest()->paginate(10);
    	return view('admin.news-letter.index', compact('newsLetters'));
    }

    public function delete($nid = '', Request $request)
    {
    	if ($request->isMethod('post')) {
            foreach ($request->con_t_id as $id) {
                $news = NewsLetter::find($id);
                // $news->profile->delete();
                $news->delete();
            }
        } elseif ($request->isMethod('get')) {
                    $news = NewsLetter::find($nid);
                    // $news->profile->delete();
                    $news->delete();
        }
        Session::flash('Success-toastr', 'Successfully deleted.');
        return redirect()->route('admin.news_letter.index');
    }
}
