<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Medication;
use DB;
use Auth;

class MedicationController extends Controller
{
    public function index()
    {
        $title =  'Medication';
        $heading =  'Medication';

        if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage Settings') == 0) {
            return back();
        }


        $data = Medication::orderBy('id', 'DESC')->get();
        return view('admin.med.index', compact('title', 'heading', 'data'));
    }
    public function add()
    {

        $title =  'Medication';
        $heading =  'Medication';

        if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage Settings') == 0) {
            return back();
        }

        return view('admin.med.add', compact('title', 'heading'));
    }
    public function addMedication(Request $request)
    {
        $t = Medication::where('title', $request->title)->where('type', $request->type)->where('unit', $request->unit)->first();
        if (!$t) {
            $request->validate([
                'title' => 'required|unique:medication,title'

            ]);
            $med =  new Medication;
            $med->title = $request->title;
            $med->type = $request->type;
            $med->unit = $request->unit;
            $med->status = 1;
            $med->save();
            return redirect()->route('admin.medication')->with('message', 'Medication added successfully');
        } else {
            return redirect()->back()->with('message', 'Medication already added');
        }
    }
    public function status_update($id, $status)
    {
        $med =  Medication::find($id);
        $med->status = $status;
        $med->save();
        return redirect()->route('admin.medication')->with('message', 'Medication updated successfully');
    }
    public function edit($id)
    {

        $title =  'Medication';
        $heading =  'Medication';

        if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage Settings') == 0) {
            return back();
        }

        $data =  Medication::where('id', $id)->first();
        return view('admin.med.edit', compact('title', 'heading', 'data'));
    }
    public function editMedication(Request $request)
    {
       

        $med =  Medication::find($request->id);
        $med->title = $request->title;
        $med->type = $request->type;
        $med->unit = $request->unit;
        $med->status = 1;
        $med->save();
        return redirect()->route('admin.medication')->with('message', 'Medication updated successfully');
    }
    public function import()
    {
        $title =  'Medication';
        $heading =  'Medication';
        if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage Settings') == 0) {
            return back();
        }
        return view('admin.med.export', compact('title', 'heading'));
    }
    public function exportMedication(Request $request)
    {

        $path = $request->file('csv_file')->getRealPath();

        $name = $request->file('csv_file')->getClientOriginalName();
        $p = explode('.', $name);
        if (str_contains($p[0], 'medication')) {

            $data = array_map('str_getcsv', file($path));


            $count = count($data);
            for ($i = 1; $i < $count; $i++) {

                DB::table('medication')->insert([
                    'title' => $data[$i][0],
                    'type' => $data[$i][1],
                    'unit' => $data[$i][2],
                    'status' => 1
                ]);
            }

            return back()->with('message', 'Medication Uploaded Successfully');
        } else {
            return back()->with('error', 'Wrong csv uploaded please Download the sample file and upload the data !');
        }
    }
    public function delete_med($id)
    {
        $med =  Medication::find($id);
       
        $med->delete();
        return redirect()->route('admin.medication')->with('message', 'Medication deleted successfully');
    }

    public function delete_all()
    {
        DB::table('medication')->delete();
        return redirect()->route('admin.medication')->with('message', 'Medication deleted successfully');
    }
}
