<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\MedicalHistory;
use DB;
use Auth;

class MedicalController extends Controller
{
    //
    public function index()
    {
        $title =  'Medical history';
        $heading =  'Medical history';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        $data = MedicalHistory::orderBy('id','DESC')->get();
        return view('admin.medical.index', compact('title', 'heading', 'data'));
    }
    public function add()
    {
        $title =  'Medical history';
        $heading =  'Medical history';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        return view('admin.medical.add', compact('title', 'heading'));
    }
    public function addMedical(Request $request)
    {
        $request->validate([
            'medical' => 'required|unique:medical_history,medical'
         
        ]);

        $lab =  new MedicalHistory;
        $lab->medical = $request->medical;
        $lab->status = 1;
        $lab->save();
        return redirect()->route('admin.medical')->with('message','Medical History added successfully');
    }
    public function status_update($id,$status)
    {
        

        $lab  =  MedicalHistory::find($id);
        $lab->status = $status;
        $lab->save();
        return redirect()->route('admin.medical')->with('message','Medical History  updated successfully');
    }
    public function edit($id)
    {
        $title =  'Medical history';
        $heading =  'Medical history';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        $data = MedicalHistory::where('id',$id)->first();
        return view('admin.medical.edit', compact('title', 'heading','data'));
    }
    public function editMedical(Request $request)
    {
        $request->validate([
            'medical' => 'required|unique:medical_history,medical,'.$request->id
         
        ]);
        $lab =  MedicalHistory::find($request->id);
        $lab->medical = $request->medical;
     
        $lab->save();
        return redirect()->route('admin.medical')->with('message','Medical History  updated successfully');
    }
    public function import()
    {
        $title =  'Medical history';
        $heading =  'Medical history';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        return view('admin.medical.export', compact('title', 'heading'));
    }
    public function exportMedical(Request $request)
    {
      
		$path = $request->file('csv_file')->getRealPath();
        $name = $request->file('csv_file')->getClientOriginalName();
        $p=explode('.',$name);
        if(str_contains($p[0], 'medical')){
            $data = array_map('str_getcsv', file($path));


            $count = count($data);
            for ($i = 1; $i < $count; $i++) {
    
                    DB::table('medical_history')->insert([
                        'medical' => $data[$i][0],
                        
                        'status'=>1
                    ]);
                    
            }
            return back()->with('message', 'Medical History Uploaded Successfully');
        }
        else{
            return back()->with('error', 'Wrong csv uploaded please Download the sample file and upload the data !');
        }
    
		
		
	}
    public function delete_med($id)
    {
        $lab =  MedicalHistory::find($id);
       
     
        $lab->delete();
        return redirect()->route('admin.medical')->with('message','Medical History  deleted successfully');
    }

    public function  delete_all()
    {
        DB::table('medical_history')->delete();
        return redirect()->route('admin.medical')->with('message','Medical History  deleted successfully');
    }
}
