<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Lab;
use DB;
use Auth;

class LabController extends Controller
{
    public function index()
    {
        $title =  'Lab history';
        $heading =  'Lab history';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        $data = Lab::orderBy('id', 'DESC')->get();
        return view('admin.lab.index', compact('title', 'heading', 'data'));
    }
    public function add()
    {
        $title =  'Lab history';
        $heading =  'Lab history';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        return view('admin.lab.add', compact('title', 'heading'));
    }
    public function addLab(Request $request)
    {
        $request->validate([
            'lab' => 'required|unique:lab,lab'

        ]);
        $lab =  new Lab;
        $lab->lab = $request->lab;
        $lab->status = 1;
        $lab->save();
        return redirect()->route('admin.lab')->with('message', 'Lab History added successfully');
    }
    public function status_update($id, $status)
    {
        $lab  =  Lab::find($id);
        $lab->status = $status;
        $lab->save();
        return redirect()->route('admin.lab')->with('message', 'Lab History updated successfully');
    }
    public function edit($id)
    {
        $title =  'Social history';
        $heading =  'Social history';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }
        $data = Lab::where('id', $id)->first();
        return view('admin.lab.edit', compact('title', 'heading', 'data'));
    }
    public function editLab(Request $request)
    {
        $lab =  Lab::find($request->id);
        $lab->lab = $request->lab;

        $lab->save();
        return redirect()->route('admin.lab')->with('message', 'Lab History updated successfully');
    }
    public function import()
    {
        $title =  'Lab History';
        $heading =  'Lab History';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        return view('admin.lab.export', compact('title', 'heading'));
    }
    public function exportLab(Request $request)
    {

        $path = $request->file('csv_file')->getRealPath();
        $name = $request->file('csv_file')->getClientOriginalName();
        $p = explode('.', $name);
        if (str_contains($p[0], 'lab')) {
            $data = array_map('str_getcsv', file($path));


            $count = count($data);
            for ($i = 1; $i < $count; $i++) {

                DB::table('lab')->insert([
                    'lab' => $data[$i][0],

                    'status' => 1
                ]);
            }

            return back()->with('message', 'Lab History Uploaded Successfully');
        } else {
            return back()->with('error', 'Wrong csv uploaded please Download the sample file and upload the data !');
        }
    }
    public function delete_lab($id)
    {
        $lab =  Lab::find($id);


        $lab->delete();
        return redirect()->route('admin.lab')->with('message', 'Lab history deleted successfully');
    }

    public function delete_all()
    {
        DB::table('lab')->delete();
        return redirect()->route('admin.lab')->with('message', 'Lab history deleted successfully');
    }
}
