<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Food;
use App\Models\Category;
use App\User;
use App\helpers;
use Session;

class FoodController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        //$categoryArr = $this->membersModel->all();

        $title =  'Product Category List';
        $heading =  'Product Category List';
        $search = $request->input('search');

        $foods = Food::with(['category', 'pub'])->select('*')
                    // ->where('is_employee',1)
                    ->when($search, function ($query) use ($search) {
                        return $query->where('name', 'LIKE', "%$search%");
                                    // ->orWhere('description', $search);
                    })
                    ->orderBy('id','DESC')
                    ->paginate(10);

        return view('admin.food.index',compact('title','foods','heading'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        // $allCountries = DB::table('countries')->get();
        $title =  'Product Category Add';
        $heading =  'Product Category Add';
        $publist = pubList();
        $categorylist = categoryList();
        return view('admin.food.create',compact('title','heading','publist','categorylist'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $validator = $request->validate([
            'name' => 'required',
            'categori_name' => 'required',
            'pub_name' => 'required',
            'price' => 'required',
            ]);

        $store = new Food;
        $store->name = $input['name'];
        $store->categori_id = $input['categori_name'];
        $store->pub_id = $input['pub_name'];
        $store->price = $input['price'];
        if ($request->hasFile('image')) {

            $file = $request->file('image');
            $imageName = $file->getClientOriginalName();
            $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);
            $image = microtime() . "." . $file_ext;
            $upload_image = $file->move(public_path('/uploads/food'), $image);
            $store->image = $image;
        }
        // $store->description = $input['description'];
        // $store->store_description = $input['store_description'];
        // $store->store_contact = $input['store_contact'];

        $store->save();
        Session::flash('Success-toastr', 'Food & Drinks Category has been inserted successfully.');

        return redirect()->route('admin.food.index')->with('alert-class','alert-success')->with('msg','Food & Drinks Category has been inserted successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Members  $members
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $title =  'Product Category Details';
        $heading =  'Product Category Details';
        // $member = $allMembers = Members::withTrashed()->where('members.id',$id)->first();

        $store = Food::find($id);

        return view('admin.food.show',compact('title','heading','store'));
    }

    public function edit($id)
    {
        // $allCountries = DB::table('countries')->get();
        $title =  'Product Category Edit';
        $heading =  'Product Category Edit';
        $storeDetailsById = Food::find($id);
        $publist = pubList();
        $categorylist = categoryList();
        return view('admin.food.edit',compact('title','heading','storeDetailsById','publist','categorylist'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Members  $members
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        $input = $request->all();
        //dd($input);
        $validator = $request->validate([
            'name' => 'required',
            'categori_name' => 'required',
            'pub_name' => 'required',
            'price' => 'required',
            ]);

        $store = Food::find($id);
        $store->name = $input['name'];
        $store->categori_id = $input['categori_name'];
        $store->pub_id = $input['pub_name'];
        $store->price = $input['price'];

        if ($request->hasFile('image')) {

            $file = $request->file('image');
            $imageName = $file->getClientOriginalName();
            $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);
            $image = microtime() . "." . $file_ext;
            $upload_image = $file->move(public_path('/uploads/food'), $image);
            $store->image = $image;
        }
        // $store->image = $input['description'];

        $store->save();
        Session::flash('Success-toastr', 'Food & Drinks has been updated successfully.');


        return redirect()->route('admin.food.index')->with('alert-class','alert-success')->with('msg','Food & Drinks has been updated successfully.');
    }


    public function destroy($id)
    {
        Food::delete($id);
        return redirect()->back()->with('alert-class','alert-success')->with('msg','Food & Drinks has been deleted successfully.');
    }

    public function restore(Request $request, $id)
    {
        $member = Food::withTrashed()->find($id);
       $member->restore();
        return redirect()->back()->with('alert-class','alert-success')->with('msg',' Successfully restored.');

    }

    public function active($id)
    {
        $user = Food::find($id);
        $user->status = '1';
        $user->save();
        Session::flash('Success-toastr', 'Food & Drinks successfully activated.');

        return redirect()->route('admin.food.index')->with('alert-class','alert-success')->with('msg','Food & Drinks successfully activated.');;
    }

    public function inactive($id)
    {
        $user = Food::find($id);
        $user->status = 0;
        $user->save();
        Session::flash('Success-toastr', 'Food & Drinks successfully inctivated.');

        return redirect()->route('admin.food.index')->with('alert-class','alert-success')->with('msg','Food & Drinks successfully inctivated.');;
    }
}
