<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\FeatureSubscription;

class FeatureSubscriptionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        //$categoryArr = $this->membersModel->all();

        $title =  'Subscriptions List';
        $heading =  'Subscriptions List';
        $search = $request->input('search');

        $subscriptions = FeatureSubscription::select('*')
                    // ->where('is_employee',1)
                    ->when($search, function ($query) use ($search) {
                        return $query->where('name', 'LIKE', "%$search%");
                                    // ->orWhere('description', $search);
                    })
                    ->orderBy('id','DESC')
                    ->paginate(10);

        return view('admin.feature-subscription.index',compact('title','subscriptions','heading'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        // $allCountries = DB::table('countries')->get();
        $title =  'Product Category Add';
        $heading =  'Product Category Add';
        return view('admin.feature-subscription.create',compact('title','heading'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $validator = $request->validate([
            'name' => 'required',
            'valid_form' => 'required',
            'price' => 'required',
        ]);

        $store = new FeatureSubscription;
        $store->name = $input['name'];
        $store->validity = $input['valid_form'];
        $store->no_of_banner = $input['no_of_banner'];
        $store->space = $input['space'];
        $store->price = $input['price'];
        // if ($request->hasFile('image')) {

        //     $file = $request->file('image');
        //     $imageName = $file->getClientOriginalName();
        //     $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);
        //     $image = microtime() . "." . $file_ext;
        //     $upload_image = $file->move(public_path('/uploads/category'), $image);
        //     $store->image = $image;
        // }
        // $store->feature = $input['feature'];
        // $store->store_description = $input['store_description'];
        // $store->store_contact = $input['store_contact'];

        $store->save();

        return redirect()->route('admin.feature-subscription.index')->with('alert-class','alert-success')->with('msg','Subscription has been inserted successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Members  $members
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $title =  'Product Category Details';
        $heading =  'Product Category Details';
        // $member = $allMembers = Members::withTrashed()->where('members.id',$id)->first();

        $store = FeatureSubscription::find($id);

        return view('admin.feature-subscription.show',compact('title','heading','store'));
    }

    public function edit($id)
    {
        // $allCountries = DB::table('countries')->get();
        $title =  'Product Category Edit';
        $heading =  'Product Category Edit';
        $storeDetailsById = FeatureSubscription::find($id);
        return view('admin.feature-subscription.edit',compact('title','heading','storeDetailsById'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Members  $members
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        $input = $request->all();
        //dd($input);
        $validator = $request->validate([
            'name' => 'required',
            'valid_form' => 'required',
            'price' => 'required',
            ]);

        $store = FeatureSubscription::find($id);
        $store->name = $input['name'];
        $store->validity = $input['valid_form'];
        $store->no_of_banner = $input['no_of_banner'];
        $store->space = $input['space'];
        $store->price = $input['price'];
        // $store->feature = $input['feature'];

        $store->save();

        return redirect()->route('admin.feature-subscription.index')->with('alert-class','alert-success')->with('msg','Product Category has been updated successfully.');
    }


    public function destroy($id)
    {
        Category::delete($id);
        return redirect()->back()->with('alert-class','alert-success')->with('msg','Product Category has been deleted successfully.');
    }

    public function restore(Request $request, $id)
    {
        $member = Category::withTrashed()->find($id);
       $member->restore();
        return redirect()->back()->with('alert-class','alert-success')->with('msg',' Successfully restored.');

    }

    public function active($id)
    {
        $user = Category::find($id);
        $user->status = '1';
        $user->save();
        return redirect()->route('category.index')->with('alert-class','alert-success')->with('msg','Product Category successfully activated.');;
    }

    public function inactive($id)
    {
        $user = Category::find($id);
        $user->status = 0;
        $user->save();
        return redirect()->route('category.index')->with('alert-class','alert-success')->with('msg','Product Category successfully inctivated.');;
    }


}
