<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Coupon;
use Session;

class CouponController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        //$categoryArr = $this->membersModel->all();

        $title =  'Product Category List';
        $heading =  'Product Category List';
        $search = $request->input('search');

        $coupons = Coupon::select('*')
                    // ->where('is_employee',1)
                    ->when($search, function ($query) use ($search) {
                        return $query->where('name', 'LIKE', "%$search%");
                                    // ->orWhere('description', $search);
                    })
                    ->orderBy('id','DESC')
                    ->paginate(10);

        return view('admin.coupon.index',compact('title','coupons','heading'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        // $allCountries = DB::table('countries')->get();
        $title =  'Product Category Add';
        $heading =  'Product Category Add';
        return view('admin.coupon.create',compact('title','heading'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $validator = $request->validate([
            'code' => 'required',
            ]);

        $store = new Coupon;
        $store->code = $input['code'];
        $store->description = $input['description'];
        $store->discount_type = $input['discount_type'];
        $store->discount = $input['discount'];
        $store->start_date = date("Y-m-d", strtotime($input['start_date']));
        $store->end_date = date("Y-m-d", strtotime($input['end_date']));
        if ($request->hasFile('image')) {

            $file = $request->file('image');
            $imageName = $file->getClientOriginalName();
            $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);
            $image = microtime() . "." . $file_ext;
            $upload_image = $file->move(public_path('/uploads/coupon'), $image);
            $store->image = $image;
        }
        // $store->image = $input['description'];
        // $store->store_description = $input['store_description'];
        // $store->store_contact = $input['store_contact'];

        $store->save();
        Session::flash('Success-toastr', 'Coupon has been inserted successfully.');

        return redirect()->route('admin.coupon.index')->with('alert-class','alert-success')->with('msg','Coupon has been inserted successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Members  $members
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $title =  'Product Category Details';
        $heading =  'Product Category Details';
        // $member = $allMembers = Members::withTrashed()->where('members.id',$id)->first();

        $coupon_dtl = Coupon::find($id);

        return view('admin.coupon.show',compact('title','heading','coupon_dtl'));
    }

    public function edit($id)
    {
        // $allCountries = DB::table('countries')->get();
        $title =  'Product Category Edit';
        $heading =  'Product Category Edit';
        $storeDetailsById = Coupon::find($id);
        return view('admin.coupon.edit',compact('title','heading','storeDetailsById'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Members  $members
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        $input = $request->all();
        //dd($input);
        $validator = $request->validate([
            'code' => 'required',
            ]);

        $store = Coupon::find($id);
        // $store->name = $input['name'];

        $store->code = $input['code'];
        $store->description = $input['description'];
        $store->discount_type = $input['discount_type'];
        $store->discount = $input['discount'];
        $store->start_date = date("Y-m-d", strtotime($input['start_date']));;
        $store->end_date = date("Y-m-d", strtotime($input['end_date']));
        // $store->image = $input['description'];
        if ($request->hasFile('image')) {

            $file = $request->file('image');
            $imageName = $file->getClientOriginalName();
            $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);
            $image = microtime() . "." . $file_ext;
            $upload_image = $file->move(public_path('/uploads/coupon'), $image);
            $store->image = $image;
        }

        $store->save();
        Session::flash('Success-toastr', 'Coupon has been updated successfully.');

        return redirect()->route('admin.coupon.index')->with('alert-class','alert-success')->with('msg','Product Category has been updated successfully.');
    }


    public function destroy($id)
    {
        Category::delete($id);
        return redirect()->back()->with('alert-class','alert-success')->with('msg','Product Category has been deleted successfully.');
    }

    public function restore(Request $request, $id)
    {
        $member = Category::withTrashed()->find($id);
       $member->restore();
        return redirect()->back()->with('alert-class','alert-success')->with('msg',' Successfully restored.');

    }

    public function send($id)
    {
        $user = Coupon::find($id);
        $user->status = '1';
        $user->save();
        return redirect()->route('admin.coupon.index')->with('alert-class','alert-success')->with('msg','Coupon send successfully.');;
    }

    public function inactive($id)
    {
        $user = Category::find($id);
        $user->status = 0;
        $user->save();
        return redirect()->route('category.index')->with('alert-class','alert-success')->with('msg','Product Category successfully inctivated.');;
    }
}
