<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ContactUs;
use App\Models\PubReview;
use App\Models\ContactUsCms;
use Session;

class ContactUsController extends Controller
{
    public function index(Request $request)
    {
        $search = $request->search;
    	$con_ts = ContactUs::when($search,function ($query) use ($search) {
            $query->where('name', 'LIKE', "%$search%")
                    ->orWhere('contact_no', 'LIKE', "%$search%")
                    ->orWhere('email_id', 'LIKE', "%$search%");
        })->latest()->paginate(10);
    	return view('admin.contact_us.index', compact('con_ts'));
    }

    public function delete($nid = '', Request $request)
    {
    	if ($request->isMethod('post')) {
            foreach ($request->con_t_id as $id) {
                $news = ContactUs::find($id);
                // $news->profile->delete();
                $news->delete();
            }
      } elseif ($request->isMethod('get')) {
                $news = ContactUs::find($nid);
                // $news->profile->delete();
                $news->delete();
      }
       Session::flash('Success-toastr', 'Successfully deleted.');
       return redirect()->route('admin.c_us');
    }

    public function contactUsCMS(Request $request)
    {
        $page = ContactUsCms::find(1);
        if ($request->isMethod('post')) {
            $page->lat = $request->lat;
            $page->long = $request->long;
            $page->phone = $request->phone;
            $page->email = $request->email;
            $page->address = $request->address;
            $page->save();
            // Session::flash('Success-toastr', 'Successfully Updated.');
            Session::flash('Success', 'Successfully Updated.');
            return back();
        }
        $heading = "Contact Us Page Edit";
        return view('admin.contact-us-cms-edit', compact('page','heading'));
    }

    public function rating_revew_list()
    {

        // $heading = "Contact Us Page Edit";
        // return view('admin.contact-us-cms-edit', compact('page','heading'));
        $reviews = PubReview::with(['pub:id,business_name,email','user:id,name,email'])->latest()->paginate(20);
        return view('admin.rating_review.index',compact('reviews'));
    }

    public function approveRatingReview($id)
    {
        PubReview::where('id',$id)
            ->update([
                'status'=> 1
            ]);
        Session::flash('Success', 'Successfully Approved.');
        return redirect()->back();
    }

}
