<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Commission;
use App\Models\User;
use DB;
use Auth;
use Illuminate\Http\Request;

class CommissionController extends Controller
{
    //
    public function commission(Request $request)
    {
        $title =  'Commission';
        $heading =  'Commission';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Commission') == 0){
            return back();
        }

        $filter = User::orderBy('id', 'DESC')->where('role', 1)->where('status', 2);

        if (isset($request->consultation_type)) {

            $filter->where('consultation_type', $request->consultation_type);
        }

        $data['data'] = $filter->get();

        return view('admin.commission.index', compact('title', 'heading'), $data);
    }
    public function global_commission()
    {
        $title =  'Global Commission';
        $heading =  'Global Commission';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Commission') == 0){
            return back();
        }

        $data['data'] = DB::table('global_commission')->orderBy('id', 'DESC')->get();

        return view('admin.commission.global', compact('title', 'heading'), $data);
    }
    public function global_store(Request $request)
    {

        $data = DB::table('global_commission')->orderBy('id', 'DESC')->first();

        if ($data) {
            DB::table('global_commission')->where('id', $data->id)->update([

                'updated_at' => date('Y/m/d h:i'),
            ]);
        }

        DB::table('global_commission')->insert([
            'percentage' => $request->per,
            'created_at' => date('Y/m/d h:i'),
        ]);


        return back()->with('message', 'Global Commission Submitted');
    }
    public function doctor_commission()
    {
        $title =  'Manage Commission';
        $heading =  'Manage Commission';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Commission') == 0){
            return back();
        }


        $data['data'] = User::where('role', 1)->where('status', 2)->get();

        return view('admin.commission.add', compact('title', 'heading'), $data);
    }
    public function commission_store(Request $request)
    {

        // if ($request->id == '') {
        //     $validator = $request->validate(
        //         [

        //             "doctor_id" => "required|unique:commission,doctor_id",

        //         ]
        //     );


        //     $com = new Commission;
        //     $msg = "Commission Inserted Successfully";
        // } else {

        //     $validator = $request->validate(
        //         [

        //             "doctor_id" => "required|unique:commission,doctor_id," . $request->id,

        //         ]
        //     );

        //     $com =  Commission::find($request->id);
        //     $msg = "Commission Updated Successfully";
        // }
        $com = User::find($request->doctor_id);
        if ($request->consultation_type == 4) {
            $com->per_con = $request->per;
        } else {
            $com->per_con = null;
        }
        $com->consultation_type = $request->consultation_type;

        $com->save();
        return Redirect()->route('admin.commission')->with('message', 'Commission Updated');
    }

    public function  g_commission()
    {
        $data = DB::table('global_commission')->first();
        if ($data) {
            return json_encode($data->percentage);
        } else {
            return json_encode(0);
        }
    }
    public function commission_edit($id)
    {
        $title =  'Commission Edit';
        $heading =  'Commission Edit';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Commission') == 0){
            return back();
        }

        $data['doctors'] = User::where('role', 1)->get();
        $data['data'] = User::find($id);

        return view('admin.commission.edit', compact('title', 'heading'), $data);
    }
    public function global_commission_edit($id)
    {
        $title =  'Global Commission';
        $heading =  'Global Commission';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Commission') == 0){
            return back();
        }

        $data['data'] = DB::table('global_commission')->orderBy('id', 'DESC')->get();
        $data['data_e'] = DB::table('global_commission')->where('id', $id)->first();
        return view('admin.commission.global_edit', compact('title', 'heading'), $data);
    }
    public function global_update(Request $request)
    {

        DB::table('global_commission')->where('id', $request->id)->update([
            'percentage' => $request->per,

        ]);

        return redirect()->route('admin.global.commission')->with('message', 'Global Commission Updated');
    }
}
