<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ColorCode;
use App\Models\User;
use DB;
use Auth;


class ColorCodeController extends Controller
{
    //
    public function index()
    {
        $title =  'Color Codes';
        $heading =  'Color Codes';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        $data['data'] = ColorCode::orderBy('id', 'DESC')->get();

        return view('admin.colorCode.index', compact('title', 'heading'), $data);
    }
    public function colorAdd()
    {
        $title =  'Color Codes';
        $heading =  'Color Codes';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        $data['data'] = ColorCode::all();

        return view('admin.colorCode.add', compact('title', 'heading'), $data);
    }
    public function colorCreate(Request $request)
    {


        if ($request->id == '') {

            $request->validate([
                'color' => 'required|unique:color_code,color',
                'type'=>'required'
            ]);
            $color = new ColorCode;
            $color->status = 1;
        } else {
            $request->validate([
                'color' => 'required|unique:color_code,color,'.$request->id,
                'type'=>'required'
            ]);
            $color = ColorCode::find($request->id);
        }

        $color->color = $request->color;
        $color->type = $request->type;
   
        $color->save();
        return redirect()->route('admin.color_code');
    }

    public function colorEdit($id)
    {
        $title =  'Color Codes Edit';
        $heading =  'Color Codes Edit';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }
        $data['data'] = ColorCode::where('id', $id)->first();

        return view('admin.colorCode.edit', compact('title', 'heading'), $data);
    }
    public function colorDelete($id){
        $title =  'Color Codes Edit';
        $heading =  'Color Codes Edit';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }
        $data['data'] = ColorCode::where('id', $id)->delete();


        return redirect()->route('admin.color_code')->with('message','Color Code Deleted Successfully');

    
    }



    public function color_status($id, $status)
    {
        ColorCode::where('id', $id)->update([
            'status' => $status
        ]);
        return back();
    }
    public function  color_code_list($id)
    {
        $title =  'Color Codes Edit';
        $heading =  'Color Codes Edit';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }

        $data['color_code'] = ColorCode::where('id', $id)->first();
        $data['color_code_patients'] = User::where('users.color_code', $id)->join('color_code', 'color_code.id', 'users.color_code')->get();

        return view('admin.colorCode.patientlist', compact('title', 'heading'), $data);
    }
    public function  med_ch_rq()
    {
        $title =  'Medicine Change Request';
        $heading =  'Medicine Change Request';

        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Medicine Change Request') == 0){
            return back();
        }

        $data['data'] =DB::table('change_medicine')->select('appointments.*','change_medicine.booking_id')->join('appointments','appointments.id','change_medicine.booking_id')->whereNotIn('patient_id',[0])->get();

        return view('admin.change_medicine.index', compact('title', 'heading'), $data);
    }

    public function  med_ch_rq_id($id)
    {
        $title =  'Medicine Change Request Edit';
        $heading =  'Medicine Change Request Edit';

        
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Medicine Change Request') == 0){
            return back();
        }
       
        $data['data'] = DB::table('change_medicine')->where('booking_id',$id)->first();
        $data['id_m']=$id;
        return view('admin.change_medicine.edit', compact('title', 'heading'),$data);
    }
    public function ch_rq($id_m,$id)
    {  
      
        $title =  'Medicine Change Request Edit';
        $heading =  'Medicine Change Request Edit';


        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Medicine Change Request') == 0){
            return back();
        }

        $data['medicine'] = DB::table('medication')->where('status',1)->get();
        $data['data'] = DB::table('doc_medicine')->where('id',$id)->first();
        $data['id_m']=$id_m;
        return view('admin.change_medicine.update', compact('title', 'heading'),$data);
    
    }
    public function ch_rq_post(Request $request)
    {
        $request->validate([
            'course' => 'required',
            'dose'=>'required'
        ]);



        DB::table('doc_medicine')->where('id',$request->id)->update([
            'medicine'=>$request->med,
            'course'=>$request->course,
            'dose'=>$request->dose,
            'frequency'=>$request->frq
        ]);
        return redirect('admin/med_ch_rq/'.$request->id_m)->with('message','Medicine  Request Changed');
    }
}
