<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Cms;
use Session;
use Illuminate\Http\Request;
use Auth;

class CmsController extends Controller
{
    public function index(Request $request)
    {
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage ') == 0){
            return back();
        }


    	$pages = Cms::orderBy('id','DESC')->get();
    	return view('admin.cms.index', compact('pages'));
    }

    public function create(Request $request)
    {
    	if ($request->isMethod('post')) {
            $validator = $request->validate(
           [
              "page_name"=>"required",
              "title"=>"required",
              "content"=>"required",
            ]);
         if( $request->id == '')  
         {
            $page = new Cms;
            $msg = 'Successfully added.';
         }
         else
         {
            $page = Cms::find($request->id);
            $msg = 'Successfully updated.';
         }
    	
    	$page->page_name = $request->page_name;
    	$page->title = $request->title;
    	$page->description = $request->content;
    	$page->save();
    	Session::flash('Success-toastr', $msg);
    	}
        return redirect()->route('admin.cms');
    }

    public function edit(Request $request,$id)
    {
        $page = Cms::find($id);
        if ($request->isMethod('post')) {
        $page->page_name = $request->page_name;
        $page->title = $request->title;
        if(in_array($page->page_name, ['PRIVATE POLICY','TERMS AND CONDITIONS','About Us','HOME PAGE BANNER CONTENT'])) {

            $page->content = $request->content;
        }

        if(in_array($page->page_name, ['About Us','Contact Us'])) {

            $page->second_title = $request->second_title;
            $page->second_content = $request->second_content;
        }
        if($page->page_name == 'Contact Us') {

            $page->third_title = $request->third_title;
            $page->third_content = $request->third_content;
        }
        if ($request->hasFile('image')) {

            $file = $request->file('image');
            $imageName = $file->getClientOriginalName();
            $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);
            $image = microtime() . "." . $file_ext;
            $upload_image = $file->move(public_path('/uploads/cms'), $image);
            $page->featured_image = $image;
        }
        if ($request->hasFile('banner_image')) {

            $file = $request->file('banner_image');
            $imageName = $file->getClientOriginalName();
            $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);
            $image = microtime() . "." . $file_ext;
            $upload_image = $file->move(public_path('/uploads/cms'), $image);
            $page->banner_image = $image;
        }
        if($request->banner_content) {
            $page->banner_content = $request->banner_content;
        }
        $page->save();
        Session::flash('Success-toastr', 'Successfully Updated.');
        }
        return view('admin.cms.edit', compact('page'));
    }

    public function delete($nid='', Request $request)
    {
      if ($request->isMethod('post')) {
            foreach ($request->page_id as $id) {
                $page = Cms::find($id);
                // $page->profile->delete();
                $page->delete();
            }
      } elseif ($request->isMethod('get')) {
                $page = Cms::find($nid);
                // $page->profile->delete();
                $page->delete();
      }
       Session::flash('Success-toastr', 'Successfully deleted.');
       return redirect()->route('admin.cms');
    }

}
