<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Category;
use Session;

class CategoryController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        //$categoryArr = $this->membersModel->all();

        $title =  'Food Category List';
        $heading =  'Food Category List';
        $search = $request->input('search');

        $categoris = Category::select('*')
                    // ->where('is_employee',1)
                    ->when($search, function ($query) use ($search) {
                        return $query->where('name', 'LIKE', "%$search%");
                                    // ->orWhere('description', $search);
                    })
                    ->orderBy('id','DESC')
                    ->paginate(10);

        return view('admin.category.index',compact('title','categoris','heading'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        // $allCountries = DB::table('countries')->get();
        $title =  'Food Category Add';
        $heading =  'Food Category Add';
        return view('admin.category.create',compact('title','heading'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $validator = $request->validate([
            'name' => 'required',
            ]);

        $store = new Category;
        $store->name = $input['name'];
        if ($request->hasFile('image')) {

            $file = $request->file('image');
            $imageName = $file->getClientOriginalName();
            $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);
            $image = microtime() . "." . $file_ext;
            $upload_image = $file->move(public_path('/uploads/category'), $image);
            $store->image = $image;
        }
        // $store->image = $input['description'];
        // $store->store_description = $input['store_description'];
        // $store->store_contact = $input['store_contact'];

        $store->save();
        Session::flash('Success-toastr', 'Food & Drinks Category has been inserted successfully.');

        return redirect()->route('admin.category.index')->with('alert-class','alert-success')->with('msg','Food & Drinks Category has been inserted successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Members  $members
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $title =  'Food Category Details';
        $heading =  'Food Category Details';
        // $member = $allMembers = Members::withTrashed()->where('members.id',$id)->first();

        $store = Category::find($id);

        return view('admin.category.show',compact('title','heading','store'));
    }

    public function edit($id)
    {
        // $allCountries = DB::table('countries')->get();
        $title =  'Food Category Edit';
        $heading =  'Food Category Edit';
        $storeDetailsById = Category::find($id);
        return view('admin.category.edit',compact('title','heading','storeDetailsById'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Members  $members
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        $input = $request->all();
        //dd($input);
        $validator = $request->validate([
            'name' => 'required',
            ]);

        $store = Category::find($id);
        $store->name = $input['name'];

        if ($request->hasFile('image')) {

            $file = $request->file('image');
            $imageName = $file->getClientOriginalName();
            $file_ext = pathinfo($imageName, PATHINFO_EXTENSION);
            $image = microtime() . "." . $file_ext;
            $upload_image = $file->move(public_path('/uploads/category'), $image);
            $store->image = $image;
        }
        // $store->image = $input['description'];

        $store->save();
        Session::flash('Success-toastr', 'Food & Drinks Category has been updated successfully.');


        return redirect()->route('admin.category.index')->with('alert-class','alert-success')->with('msg','Food & Drinks Category has been updated successfully.');
    }


    public function destroy($id)
    {
        Category::delete($id);
        return redirect()->back()->with('alert-class','alert-success')->with('msg','Product Category has been deleted successfully.');
    }

    public function restore(Request $request, $id)
    {
        $member = Category::withTrashed()->find($id);
       $member->restore();
        return redirect()->back()->with('alert-class','alert-success')->with('msg',' Successfully restored.');

    }

    public function active($id)
    {
        $user = Category::find($id);
        $user->status = '1';
        $user->save();
        Session::flash('Success-toastr', 'Food & Drinks Category successfully activated.');

        return redirect()->route('admin.category.index')->with('alert-class','alert-success')->with('msg','Food & Drinks Category successfully activated.');;
    }

    public function inactive($id)
    {
        $user = Category::find($id);
        $user->status = 0;
        $user->save();
        Session::flash('Success-toastr', 'Food & Drinks Category successfully inctivated.');

        return redirect()->route('admin.category.index')->with('alert-class','alert-success')->with('msg','Food & Drinks Category successfully inctivated.');;
    }
}
