<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BodyPartCat;
use App\Models\BodyPartSubCat;
use App\Models\ParentCat;
use App\Models\Symptoms;
use App\Models\ColorCode;
use DB;
use Illuminate\Support\Facades\URL;

class BodyPartController extends Controller
{
    public function index()
    {
        $title =  'Body Part Category';
        $heading =  'Body Part Category';
        $data = BodyPartCat::select('symptoms.*', 'problems.problem')->join('problems', 'problems.id', 'symptoms.pro_id')->orderBy('id', 'DESC')->get();
        return view('admin.body_cat.index', compact('title', 'heading', 'data'));
    }

    public function add()
    {
        $title =  'Body Part Category';
        $heading =  'Body Part Category';
        $data = ParentCat::orderBy('id', 'ASC')->get();
        return view('admin.body_cat.add', compact('title', 'heading', 'data'));
    }
    public function create(Request $request)
    {
        $b =  new BodyPartCat;


        if ($request->hasFile('img')) {
            $file_type = $request->file('img')->extension();
            $file_path = $request->file('img')->storeAs('images/doctors', time() . '.' . $file_type, 'public');
            $request->file('img')->move(public_path('images/doctors'), time() . '.' . $file_type);
            $b->img = URL::to('/') . '/' . $file_path;
        }

        $b->pro_id = $request->pro_id;
        $b->symptoms = $request->symptoms;
        $b->type = $request->type;
        $b->priority = $request->priority;
        $b->status = 1;
        $b->save();
        return redirect()->route('admin.body_cat')->with('message', 'Problem Symptoms added successfully');
    }
    public function status($id, $status)
    {
        $b =   BodyPartCat::find($id);

        $b->status = $status;
        $b->save();
        return redirect()->route('admin.body_cat')->with('message', 'Problem Symptoms Status Updated');
    }
    public function  edit($id)
    {
        $title =  'Body Part Category';
        $heading =  'Body Part Category';
        $data = ParentCat::orderBy('id', 'ASC')->get();
        $b =   BodyPartCat::find($id);
        return view('admin.body_cat.edit', compact('title', 'heading', 'b', 'data'));
    }
    public function editBodyCat(Request $request)
    {
        $b =   BodyPartCat::find($request->id);
        if ($request->hasFile('img')) {
            $file_type = $request->file('img')->extension();
            $file_path = $request->file('img')->storeAs('images/doctors', time() . '.' . $file_type, 'public');
            $request->file('img')->move(public_path('images/doctors'), time() . '.' . $file_type);
            $b->img = URL::to('/') . '/' . $file_path;
        } else {
            if($request->img_o != ''){
                $b->img = $request->img_o;
            }
            else{
                $b->img = "";
            }
           
        }
        $b->pro_id = $request->pro_id;
        $b->symptoms = $request->symptoms;
        $b->type = $request->type;
        $b->priority = $request->priority;

        $b->save();


        return redirect()->route('admin.body_cat')->with('message', 'Problem Symptoms Updated');
    }
    public function sub_cat()
    {
        $title =  'Body Part Sub-Category';
        $heading =  'Body Part Sub-Category';
        $data = BodyPartSubCat::select('treatments.*', 'color_code.color')->join('color_code', 'color_code.id', 'treatments.color_code')->orderBy('treatments.id', 'DESC')->get();
        return view('admin.sub_cat.index', compact('title', 'heading', 'data'));
    }
    public function sub_cat_add()
    {
        $title =  'Body Part Sub-Category';
        $heading =  'Body Part Sub-Category';
        $data = ColorCode::orderBy('id', 'ASC')->get();
        //$data = BodyPartCat::orderBy('id','DESC')->get();
        return view('admin.sub_cat.add', compact('title', 'heading', 'data'));
    }
    public function  sub_cat_create(Request $request)
    {
        $request->validate([
            'treatment' => 'required|unique:treatments,treatments',


        ]);
        $b =  new BodyPartSubCat;
        $b->color_code = $request->color_code;

        $b->treatments = $request->treatment;
        $b->status = 1;
        $b->save();
        return redirect()->route('admin.sub_cat_index')->with('message', 'Treatment Added');
    }
    public function body_subcat_status($id, $status)
    {
        $b =   BodyPartSubCat::find($id);
        $b->status = $status;
        $b->save();
        return redirect()->route('admin.sub_cat_index')->with('message', 'Treatment Updated');
    }
    public function subcat_edit($id)
    {
        $title =  'Body Part Sub-Category';
        $heading =  'Body Part Sub-Category';

        $b =   BodyPartSubCat::find($id);
        $data = ColorCode::orderBy('id', 'ASC')->get();

        return view('admin.sub_cat.edit', compact('title', 'heading', 'b', 'data'));
    }
    public function editBodySubCat(Request $request)
    {

        $request->validate([
            'treatment' => 'required',

        ]);


        $b =  BodyPartSubCat::find($request->id);
        $b->color_code = $request->color_code;

        $b->treatments = $request->treatment;


        $b->save();
        return redirect()->route('admin.sub_cat_index')->with('message', 'Treatment Updated');
    }
    public function  p_cat_list()
    {
        $title =  'Body Part Parent-Category';
        $heading =  'Body Part Parent-Category';
        $data = DB::table('problems')->orderBy('id', 'DESC')->get();
        return view('admin.parent_cat.index', compact('title', 'heading', 'data'));
    }

    public function p_cat_list_a()
    {
        $title =  'Body Part Parent-Category';
        $heading =  'Body Part Parent-Category';
        $data = DB::table('problems')->where('age_b', 'Adult')->orderBy('id', 'DESC')->get();
        return view('admin.parent_cat.index', compact('title', 'heading', 'data'));
    }

    public function p_cat_list_p()
    {
        $title =  'Body Part Parent-Category';
        $heading =  'Body Part Parent-Category';
        $data = DB::table('problems')->where('age_b', 'Pediatric')->orderBy('id', 'DESC')->get();
        return view('admin.parent_cat.index', compact('title', 'heading', 'data'));
    }

    public function  p_cat_add()
    {
        $title =  'Parent Category Add';
        $heading =  'Parent Category Add';

        return view('admin.parent_cat.add', compact('title', 'heading'));
    }
    public function p_cat_create(Request $request)
    {
        $validatedData = $request->validate([
            'problem' => 'required',
        ]);
        if ($request->hasFile('image')) {
            $file_type = $request->file('image')->extension();
            $file_path = URL::to('/') . '/' . $request->file('image')->storeAs('images/doctors', time() . '.' . $file_type, 'public');
            $request->file('image')->move(public_path('images/doctors'), time() . '.' . $file_type);
        } else {
            $file_path = "https://tse4.mm.bing.net/th?id=OIP.q9_sa8o-SnWYRZ1rhn5FQAHaHR&pid=Api&P=0&w=300&h=300";
        }

        $b =  new ParentCat;
        $b->problem = $request->problem;
        $b->age_b = $request->age_b;
        $b->status = 1;
        $b->img = $file_path;
        $b->save();
        if ($request->age_b == 'Adult') {
            return redirect()->route('admin.p_cat_list_a')->with('message', 'Chief Complaint Added Successfully');
        } else {
            return redirect()->route('admin.p_cat_list_p')->with('message', 'Chief Complaint Added Successfully');
        }
    }
    public function p_cat_status($id, $status)
    {
        $b =   ParentCat::find($id);

        $b->status = $status;
        $b->save();
        return redirect()->route('admin.p_cat_list')->with('message', 'Chief Complaint Status Updated');
    }

    public function p_cat_top($id, $status)
    {
        $b =   ParentCat::find($id);

        $b->top = $status;
        $b->save();

        if ($b->age_b == 'Adult') {
            return redirect()->route('admin.p_cat_list_a')->with('message', 'Chief Complaint Under Top 10');
        } else {
            return redirect()->route('admin.p_cat_list_p')->with('message', 'Chief Complaint Under Top 10');
        }
    }
    public function  p_cat_edit($id)
    {
        $title =  'Body Part Parent-Category';
        $heading =  'Body Part Parent-Category';
        $data = ParentCat::find($id);
        return view('admin.parent_cat.edit', compact('title', 'heading', 'data'));
    }
    public function  p_cat_update(Request $request)
    {
        $validatedData = $request->validate([
            'problem' => 'required',
        ]);
        if ($request->hasFile('image')) {
            $file_type = $request->file('image')->extension();
            $file_path = URL::to('/') . '/' . $request->file('image')->storeAs('images/doctors', time() . '.' . $file_type, 'public');
            $request->file('image')->move(public_path('images/doctors'), time() . '.' . $file_type);
        } else {
            $file_path = $request->image_old;
        }


        $b =  ParentCat::find($request->id);
        $b->problem = $request->problem;
        $b->age_b = $request->age_b;
        $b->img = $file_path;
        $b->save();
        if ($request->age_b == 'Adult') {
            return redirect()->route('admin.p_cat_list_a')->with('message', 'Chief Complaint Added Successfully');
        } else {
            return redirect()->route('admin.p_cat_list_p')->with('message', 'Chief Complaint Added Successfully');
        }
    }
    public function p_cat_delete($id)
    {
        $b =  ParentCat::where('id', $id)->delete();

        return redirect()->route('admin.p_cat_list')->with('message', 'Chief Complaint Deleted Successfully');
    }
    public function getCat(Request $request)
    {
        $data = DB::table('body_cat')->where('p_cat_id', $request->p_cat_id)->get();
        $t = [];
        foreach ($data as $row) {
            $data = "<option value=" . $row->id . ">" . $row->category . "</option>";
            array_push($t, $data);
        }
        echo implode($t);;
    }
    public function  symptoms()
    {
        $title =  'Diagnosis';
        $heading =  'Diagnosis';
        $data = DB::table('diagnosis')
            ->select('diagnosis.*', 'symptoms.symptoms', 'problems.problem', 'problems.age_b')
            ->join('symptoms', 'symptoms.id', 'diagnosis.symp_id')
            ->join('problems', 'symptoms.pro_id', 'problems.id')
            ->get();
        return view('admin.symptoms.index', compact('title', 'heading', 'data'));
    }
    public function symptom_status($id, $status)
    {
        $data = Symptoms::where('id', $id)->update([
            'status' => $status
        ]);
        return redirect()->route('admin.symptoms')->with('message', 'Diagnosis status Update Successfully');
    }
    public function symptoms_add()
    {
        $title =  'Body Part Symptoms';
        $heading =  'Body Part Symptoms';
        $data = DB::table('symptoms')
            ->select('symptoms.*', 'problems.problem', 'problems.age_b')
            ->join('problems', 'symptoms.pro_id', 'problems.id')
            ->get();

        return view('admin.symptoms.add', compact('title', 'heading', 'data'));
    }
    public function symptoms_create(Request $request)
    {

        $request->validate([
            'diagnosis' => 'required',

        ]);


        $data = DB::table('diagnosis')->insert([
            'symp_id' => $request->symp_id,
            'diagnosis' => preg_replace("/\s*,\s*/", ",", $request->diagnosis),

        ]);
        return redirect()->route('admin.symptoms')->with('message', 'Diagnosis added Successfully');
    }
    public function symptoms_edit($id)
    {
        $title =  'Body Part Symptoms';
        $heading =  'Body Part Symptoms';
        $data_p =  DB::table('diagnosis')->where('id', $id)->first();
        $data = DB::table('symptoms')
            ->select('symptoms.*', 'problems.problem')

            ->join('problems', 'symptoms.pro_id', 'problems.id')
            ->get();


        return view('admin.symptoms.edit', compact('title', 'heading', 'data', 'data_p'));
    }
    public function symptoms_update(Request $request)
    {
        $request->validate([
            'diagnosis' => 'required',

        ]);


        $data =  DB::table('diagnosis')->where('id', $request->id)->update([
            'symp_id' => $request->symp_id,
            'diagnosis' => preg_replace("/\s*,\s*/", ",", $request->diagnosis),
        ]);
        return redirect()->route('admin.symptoms')->with('message', 'Diagnosis Updated Successfully');
    }


    public function s_type()
    {
        $title =  'Problems Related Questions';
        $heading =  'Problems Related Questions';
        $data = DB::table('type')->select('type.*', 'problems.problem')->join('problems', 'problems.id', 'type.pro_id')->orderBy('order')->get();
        return view('admin.type.list', compact('title', 'heading', 'data'));
    }

    public function  s_add()
    {
        $title =  'Symptom Type';
        $heading =  'Symptom Type';


        return view('admin.type.add', compact('title', 'heading'));
    }
    public function  s_create(Request $request)
    {



        $r = DB::table('type')->where('pro_id', $request->pro_id)->where('order', $request->order)->first();

        if (!$r && $request->id == '') {

            $request->validate([
                'question' => 'required',
            ]);

            DB::table('type')->insert([
                'type' => $request->question,
                'pro_id' => $request->pro_id,
                'order' => $request->order,
                'status' => 1
            ]);
            return redirect()->route('admin.s_type')->with('message', 'Question Added Successfully');
        } elseif ($r->id == $request->id && $request->id != '') {
            DB::table('type')->where('id', $request->id)->update([
                'type' => $request->type,
                'pro_id' => $request->pro_id,
                'order' => $request->order
            ]);
            return redirect()->route('admin.s_type')->with('message', 'Question Updated Successfully');
        } else {
            return back()->with('message', "Order number under same problem should not be same");
        }
    }

    public function s_edit($id)
    {
        $title =  'Symptom Type';
        $heading =  'Symptom Type';

        $data = DB::table('type')->where('id', $id)->first();
        return view('admin.type.edit', compact('title', 'heading', 'data'));
    }

    public function  s_delete($id)
    {
        $data = DB::table('type')->where('id', $id)->delete();
        $p = DB::table('symptoms')->where('type', $id)->get();

        $users = json_decode(json_encode($p), true);
        $_add_on = array_column($users, 'id');

        DB::table('diagnosis')->whereIn('symp_id', $_add_on)->delete();
        DB::table('symptoms')->where('type', $id)->delete();
        return back()->with('message', 'Question deleted');
    }


    public function  questions(Request $request)
    {

        $data = DB::table('type')->where('pro_id', $request->pro_id)->get();
        return response()->json($data);
    }
    public function body_cat_delete($id)
    {
        $data = DB::table('symptoms')->where('id', $id)->delete();
        return back()->with('message', 'Symptom deleted');
    }

    public function import_problems()
    {
        $title =  'Import Problems';
        $heading =  'Import Problems';


        return view('admin.parent_cat.import', compact('title', 'heading'));
    }

    public function import_problems_post(Request $request)
    {

        $path = $request->file('csv_file')->getRealPath();

        $name = $request->file('csv_file')->getClientOriginalName();
        $p = explode('.', $name);
        if (str_contains($p[0], 'problems')) {

            $data = array_map('str_getcsv', file($path));


            $count = count($data);
            for ($i = 1; $i < $count; $i++) {

                $p = ltrim($data[$i][0], " ");

                $r = rtrim($p, " ");


                DB::table('problems')->insert([
                    'problem' => $r,
                    'age_b' => $data[$i][1],
                    'status' => 1
                ]);
            }

            return back()->with('message', 'Problems Uploaded Successfully');
        } else {
            return back()->with('error', 'Wrong CSV has uploaded. Please upload the sample file after filling up required data !');
        }
    }
    public function import_treatments_post(Request $request)
    {

        $path = $request->file('csv_file')->getRealPath();

        $name = $request->file('csv_file')->getClientOriginalName();
        $p = explode('.', $name);
        if (str_contains($p[0], 'treatments')) {
            $data = array_map('str_getcsv', file($path));


            $count = count($data);
            for ($i = 1; $i < $count; $i++) {
                if ($data[$i][1] == 'Red') {
                    $c = 1;
                } else if ($data[$i][1] == 'Yellow') {
                    $c = 2;
                } else {
                    $c = 3;
                }
                $p = ltrim($data[$i][0], " ");

                $r = rtrim($p, " ");



                DB::table('treatments')->insert([
                    'treatments' => $r,
                    'color_code' => $c,
                    'status' => 1
                ]);
            }

            return back()->with('message', 'Treatments Uploaded Successfully');
        } else {
            return back()->with('error', 'Wrong CSV has uploaded. Please upload the sample file after filling up required data !');
        }
    }

    public function import_treatments()
    {
        $title =  'Import Treatments';
        $heading =  'Import Treatments';
        return view('admin.sub_cat.import', compact('title', 'heading'));
    }

    public function import_questions()
    {
        $title =  'Import Treatments';
        $heading =  'Import Treatments';
        return view('admin.type.import', compact('title', 'heading'));
    }

    public function import_questions_post(Request $request)
    {
        $path = $request->file('csv_file')->getRealPath();

        $name = $request->file('csv_file')->getClientOriginalName();
        $p = explode('.', $name);
        if (str_contains($p[0], 'questions')) {

            $data = array_map('str_getcsv', file($path));


            $count = count($data);
            for ($i = 1; $i < $count; $i++) {
                $p = DB::table('problems')->where('problem', $data[$i][0])->where('age_b', $data[$i][1])->first();



                if (!$p) {
                    $pr = 0;
                } else {
                    $pr = $p->id;
                }

                $l = ltrim($data[$i][2], " ");

                $r = rtrim($l, " ");




                DB::table('type')->insert([
                    'type' => $r,
                    'pro_id' => $pr,
                    'order' => $data[$i][3],
                    'status' => 1
                ]);
            }

            return back()->with('message', 'Question Uploaded Successfully');
        } else {
            return back()->with('error', 'Wrong CSV has uploaded. Please upload the sample file after filling up required data !');
        }
    }

    public function import_diagnosis()
    {
        $title =  'Import Diagnosis';
        $heading =  'Import Diagnosis';
        return view('admin.symptoms.import', compact('title', 'heading'));
    }

    public function   import_diagnosis_post(Request $request)
    {
        $path = $request->file('csv_file')->getRealPath();
        $data = array_map('str_getcsv', file($path));


        $count = count($data);
        for ($i = 1; $i < $count; $i++) {
            $p = DB::table('problems')->where('problem', $data[$i][0])->where('age_b', $data[$i][1])->first();
            $s = DB::table('symptoms')->where('pro_id', $p->id)->first();


            DB::table('diagnosis')->insert([

                'symp_id' => $s->id,
                'diagnosis' => $data[$i][3]

            ]);
        }

        return back()->with('message', 'Diagnosis Uploaded Successfully');
    }

    public function body_cat_import()
    {
        $title =  'Import Symptoms';
        $heading =  'Import Symptoms';
        return view('admin.body_cat.import', compact('title', 'heading'));
    }
    public function body_cat_import_post(Request $request)
    {
        $path = $request->file('csv_file')->getRealPath();

        $name = $request->file('csv_file')->getClientOriginalName();
        $p = explode('.', $name);
        if (str_contains($p[0], 'symptoms_problems')) {

            $data = array_map('str_getcsv', file($path));


            $count = count($data);


            for ($i = 1; $i < $count; $i++) {


                $p = DB::table('problems')->where('problem', $data[$i][0])->where('age_b', $data[$i][1])->first();


                if (!$p) {
                    $pr = 0;
                } else {

                    $pr = $p->id;
                }

                $t_c = DB::table('type')->where('pro_id', $pr)->where('type', $data[$i][2])->first();

                if (!$t_c) {

                    $t = DB::table('type')->insertGetId([
                        'type' => $data[$i][2],
                        'pro_id' => $pr,
                        'order' => $data[$i][3],
                        'status' => 1
                    ]);
                } else {
                    $t = $t_c->id;
                }


                $s = DB::table('symptoms')->insertGetId([

                    'pro_id' => $pr,
                    'type' => $t,
                    'symptoms' => $data[$i][4],
                    'priority' => $data[$i][5],
                    'img' => $data[$i][6],
                    'status' => 1

                ]);

                $d = DB::table('diagnosis')->insert([

                    'symp_id' => $s,
                    'diagnosis' => preg_replace("/\s*,\s*/", ",", $data[$i][7]),

                ]);
            }

            return back()->with('message', 'Symptoms Uploaded Successfully');
        } else {
            return back()->with('error', 'Wrong CSV has uploaded. Please upload the sample file after filling up required data !');
        }
    }


    public function subcat_delete($id)
    {
        DB::table('treatments')->where('id', $id)->delete();

        return back()->with('message', 'Treatment Deleted Successfully');
    }
    public function symptoms_delete($id)
    {
        DB::table('diagnosis')->where('id', $id)->delete();

        return back()->with('message', 'Diagnosis Deleted Successfully');
    }
    public function delete_problems()
    {
        $title =  'Delete Chief Complaint Related Records';
        $heading =  'Delete Chief Complaint Related Records';

        $data = DB::table('problems')->get();

        return view('admin.symptoms.delete', compact('title', 'heading', 'data'));
    }
    public function getProblem(Request $request)
    {
        $data = DB::table('problems')->where('age_b', $request->age)->get();

        return response()->json($data);
    }
    public function delete_problems_post(Request $request)
    {
        $p = implode(',', $request->pro_id);
        if (str_contains($p, 'All')) {

            $data = DB::table('problems')->where('age_b', $request->age)->get();
            $users = json_decode(json_encode($data), true);
            $_add_on = array_column($users, 'id');
            $i = implode(',', $_add_on);
            $data_t = DB::table('type')->whereIn('pro_id', explode(',', $i))->delete();

            $data_s = DB::table('symptoms')->whereIn('pro_id', explode(',', $i))->get();

            foreach ($data_s as $r) {
                DB::table('diagnosis')->where('symp_id', $r->id)->delete();
            }



            $data_s = DB::table('symptoms')->whereIn('pro_id', explode(',',$i))->get();
        } else {



            $data_t = DB::table('type')->whereIn('pro_id', $request->pro_id)->delete();

            $data_s = DB::table('symptoms')->whereIn('pro_id', $request->pro_id)->get();

            foreach ($data_s as $r) {
                DB::table('diagnosis')->where('symp_id', $r->id)->delete();
            }

            $data_s = DB::table('symptoms')->whereIn('pro_id', $request->pro_id)->delete();
        }


        return back()->with('message', 'Records Deleted Successfully');
    }


    public function earning()
    {
        
        $title =  "List of doctor's earnings";
        $heading =  "List of doctor's earnings";

        $data = DB::table('users')->where('role',1)->where('status',2)->get();

        return view('admin.commission.list_of_earnings', compact('title', 'heading', 'data'));
    }
}
