<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Appointment;
use App\Models\User;
use App\Models\Service;
use Illuminate\Http\Request;
use Auth;

class AppointmentController extends Controller
{
    //
    public function appointments(Request $request)
    {
        $title =  'Appointments';
        $heading =  'Appointments';

        if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Appointment') == 0) {
            return back();
        }
        if ($request->from_date > $request->to_date) {
            return back()->with('message', 'Invalid Date Range');
        }
     

        $filter =  Appointment::with('doctor', 'patient');
        if (isset($request->from_date)) {
            $filter->whereBetween('date', [$request->from_date, $request->to_date]);
        }
        if (isset($request->spl_id)) {
            $filter->where('spl_id', $request->spl_id);
        }
        if (isset($request->con_type)) {
            $filter->where('consultation_type', $request->con_type);
        }

        $data['services'] = Service::all();
        $appointments = $filter->where('app_type','B')->orderBy('id', 'DESC')->get();
        $u = [];

        foreach ($appointments as $row) {
            if ($row->payment_status !== null) {
                array_push($u,$row);
            }
        }
       
        $data['appointments']=$u;




        return view('admin.appoinment.index', compact('title', 'heading'), $data);
    }
    public function appointments_view($id)
    {
        $title =  'Appointments Details';
        $heading =  'Appointments Details';
        if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Appointment') == 0) {
            return back();
        }
        $data['appointment'] = Appointment::with('doctor', 'patient', 'specialization')->where('id', $id)->first();

        return view('admin.appoinment.view', compact('title', 'heading'), $data);
    }

    public function q_appointment(Request $request)
    {
        $title =  'Appointments';
        $heading =  'Appointments';

        if (chk_permission(Auth::guard('siteAdmin')->user()->id, 'Manage QuickVisit') == 0) {
            return back();
        }

        if ($request->from_date > $request->to_date) {
            return back()->with('message', 'Invalid Date Range');
        }

        $filter =  Appointment::with('doctor','patient','speciali')->where('app_type','Q');
        if (isset($request->from_date)) {
            $filter->whereBetween('date', [$request->from_date, $request->to_date]);
        }

        if (isset($request->con_type)) {
            $filter->where('consultation_type', $request->con_type);
        }


        $data['appointments'] = $filter->orderBy('id', 'DESC')->get();
        return view('admin.appoinment.quick_visit', compact('title', 'heading'), $data);
    }
}
