<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Allergy;
use DB;
use Auth;

class AllergiesController extends Controller
{
    //
    public function index()
    {
        $title =  'Allergy';
        $heading =  'Allergy';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }
        $data = Allergy::all();
        return view('admin.allergy.index', compact('title', 'heading', 'data'));
    }
    public function add()
    {
        $title =  'Allergy Create';
        $heading =  'Allergy Create';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }
        return view('admin.allergy.add', compact('title', 'heading'));
    }
    public function addAllergy(Request $request)
    {
        $request->validate([
            'allergy' => 'required|unique:allergies,allergy'
         
        ]);



      $allergy =  new Allergy;
      $allergy->allergy = $request->allergy;
      $allergy->status = 1;
      $allergy->save();
      return redirect()->route('admin.allergies')->with('message','Allergy added successfully');

    }
    public function status_update($id,$status)
    {

        $allergy =  Allergy::find($id);
        $allergy->status = $status;
        $allergy->save();
        return redirect()->route('admin.allergies')->with('message','Allergy updated successfully');
    }
    public function edit($id)
    {
        $title =  'Allergy Edit';
        $heading =  'Allergy Edit';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }
        $data = Allergy::where('id',$id)->first();
        return view('admin.allergy.edit', compact('title', 'heading','data'));
    }
    public function editAllergy(Request $request)
    {
        $request->validate([
            'allergy' => 'required|unique:allergies,allergy,'.$request->id
         
        ]);


      $allergy =   Allergy::find($request->id);
      $allergy->allergy = $request->allergy;
  
      $allergy->save();
      return redirect()->route('admin.allergies')->with('message','Allergy updated successfully');

    }
    public function import()
    {
        $title =  'Allergy';
        $heading =  'Allergy';
        if(chk_permission(Auth::guard('siteAdmin')->user()->id,'Manage Settings') == 0){
            return back();
        }
        return view('admin.allergy.export', compact('title', 'heading'));
    }
    public function exportAllergy(Request $request)
    {
      
		$path = $request->file('csv_file')->getRealPath();

        $name = $request->file('csv_file')->getClientOriginalName();
        $p=explode('.',$name);
        if(str_contains($p[0], 'allergy')){
            $data = array_map('str_getcsv', file($path));


            $count = count($data);
            for ($i = 1; $i < $count; $i++) {
    
                    DB::table('allergies')->insert([
                        'allergy' => $data[$i][0],
                        
                        'status'=>1
                    ]);
                    
            }
    
            return back()->with('message', 'Allergy Uploaded Successfully');

        }
        else{
            return back()->with('error', 'Wrong csv uploaded please Download the sample file and upload the data !');
        }



		
	}
    public function delete_allergy($id)
    {
        $allergy =   Allergy::find($id);
     
    
        $allergy->delete();
        return redirect()->route('admin.allergies')->with('message','Allergy deleted successfully');
    }
    public function delete_all()
    {
        DB::table('allergies')->delete();
        return redirect()->route('admin.allergies')->with('message','Medical History  deleted successfully');
    }

}
