<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SiteSetting;
use App\Models\UserProfile;
use App\Models\Category;
use App\Models\Coupon;
use App\Models\BusinessCategory;
use App\Models\VendorSubscription;
use App\Models\VendorFeatureSubscription;
use App\Models\User;
use App\Models\Service;
use App\Models\Appointment;
use Auth;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Mail\Registration;
use Illuminate\Support\Facades\Mail;
use DB;


use Session;
use Validator;

class AdminController extends Controller
{
  function index()
  {


    $doctors = User::where('role', 1)->where('status', 2)->count();
    $patients = User::where('role', 2)->where('status', 1)->count();
    // $category = Category::where('status',1)->count();
    // $coupon = Coupon::count();
    $service = Service::count();
    $appointment = Appointment::where('app_type','B')->where('payment_status','!=',null)->count();
    $appointment_q = Appointment::where('app_type', 'Q')->count();
    $admins = User::where('role', 0)->where('status', 1)->count();

   

    // $revenue_f_subs = VendorFeatureSubscription::sum('price');

    $category = 5;
    $coupon = 2;
    $busness_type = 6;
    $revenue_subs = 1500;
    $revenue_f_subs = 1000;

    return view('admin.index', compact('doctors', 'patients', 'coupon', 'category', 'service', 'appointment', 'revenue_f_subs', 'admins', 'appointment_q'));
  }

  public function test($mail)
  {
    Mail::to($mail)->send(new Registration(6));
  }

  function adminLogin(Request $request)
  {
    // echo Hash::make('123456'); exit;
    if (Auth::guard('siteAdmin')->check()) {
      return redirect()->route('admin.dashboard');
    }

    if ($request->all()) {
      $validator = $request->validate(
        [
          "email" => "required|email",
          "password" => "required",
        ],
        [
          "email.email" => "Enter valid email addess.",
        ]
      );
      // if(!$validator->fails()){
      $user_info = array(
        "email" => $request->email,
        "password" => $request->password,
        "role" => 0,
        "status" => 1
      );

      if (Auth::guard("siteAdmin")->attempt($user_info) && Auth::attempt($user_info)) {
        $user_details = Auth::guard("siteAdmin")->user();
        return redirect()->route('admin.dashboard');
      } else {
        Session::flash('Error-toastr', 'Invalid credentials or profile not active');
        return redirect()->route('admin.login');
      }
    }
    return view('admin.login');
  }



  function createAdmin(Request $request)
  {
    $result = Admin::create([
      'name' => 'debkumar mayra',
      'email' => 'debkumar@gmail.com',
      'password' => Hash::make('123456'),
    ]);

    echo $result ? 'success' : 'fail';
  }


  function profile()
  {
    $user = request()->user();
    return view('admin.profile', compact('user'));
  }

  function updateProfile(Request $request)
  {

    $data = $request->validate([
      "name" => "sometimes|required|min:3|max:100",
      'email' => 'sometimes|nullable|required|unique:users,email',
      "mobile" => "sometimes|nullable|digits:10",
      "dob" => "sometimes|nullable|date|before_or_equal:" . now()->subYears(13)->format('Y-m-d'),
      "profile_photo" => "sometimes|nullable|image|mimes:jpeg,png,jpg|max:2048",
      "old_password" => "sometimes|nullable|required",
      "new_password" => "sometimes|nullable|required|min:6",
      "confirm_password" => "sometimes|nullable|required|same:new_password",
    ], ['dob.before_or_equal' => 'You must be 13 years old or above.']);
    try {
      $user = Auth::guard('siteAdmin')->user();
      if (!empty($request->name)) $user->name = $request->name;
      if (!empty($request->email)) $user->email = $request->email;
      if (isset($request->old_password) && !empty($request->old_password)) {
        if (!(Hash::check($request->old_password, Auth::guard('siteAdmin')->user()->password))) {
          Session::flash('Error-toastr', 'Your old password does not matches');
          return redirect()->back();
        } elseif (!empty($request->new_password)) {
          $user->password = Hash::make($request->new_password);
        }
      }

      $user->save();
      $profile = UserProfile::where('user_id', $user->id)->first();
      $profile = $profile ?? new UserProfile;
      $profile->user_id = $user->id;

      if (!empty($request->dob)) $profile->dob = $request->dob;
      if (!empty($request->mobile)) $profile->mobile = $request->mobile;
      if (!empty($request->gender)) $profile->gender = $request->gender;
      if (!empty($request->address)) $profile->address = $request->address;
      if (!empty($request->about)) $profile->about = $request->about;

      if ($request->hasFile('profile_photo')) {
        $rand_val           = date('YMDHIS') . rand(11111, 99999);
        $image_file_name    = md5($rand_val);
        $file               = $request->file('profile_photo');
        $extension          = $request->file('profile_photo')->extension();
        $fileName           = $image_file_name . '.' . $extension;
        $destinationPath    = public_path() . '/uploads/users/';
        $file->move($destinationPath, $fileName);
        $profile->profile_photo = $fileName;
      }
      $profile->save();
      Session::flash('Success-toastr', 'Profile Successfully updated');
    } catch (\Exception $e) {
      Session::flash('Error-toastr', $e->getMessage());
    }
    return redirect()->back();
  }

  function settings(Request $request)
  {
    if ($request->isMethod('post')) {

      if ($request->hasFile('logo')) {
        // $rand_val           = date('YMDHIS').rand(11111,99999);
        // $image_file_name    = md5($rand_val);
        $file               = $request->file('logo');
        $extension          = $request->file('logo')->extension();
        $fileName           = 'logo.' . $extension;
        $destinationPath    = public_path() . '/common_img/';
        $file->move($destinationPath, $fileName);
        $logo = SiteSetting::firstOrNew(['key' => 'logo']);
        $logo->key = 'logo';
        $logo->value = $fileName;
        $logo->save();
      }
      $email = SiteSetting::firstOrNew(['key' => 'email']);
      $email->key = 'email';
      $email->value = $request->email;
      $email->save();

      $date_format = SiteSetting::firstOrNew(['key' => 'date_format']);
      $date_format->key = 'date_format';
      $date_format->value = strtoupper($request->date_format);
      $date_format->save();

      $per_page = SiteSetting::firstOrNew(['key' => 'per_page']);
      $per_page->key = 'per_page';
      $per_page->value = strtoupper($request->per_page);
      $per_page->save();

      return redirect()->back()->with('Success-toastr', 'Successfully updated');
    }
    return view('admin.settings');
  }
  public function showChangePasswordForm()
  {
    $title =  'Change Password';
    $heading =  'Change Password';
    return view('admin.auth.changepassword', compact('title', 'heading'));
  }

  public function changePassword(Request $request)
  {

    if (!(Hash::check($request->get('current_password'), Auth::user()->password))) {
      // The passwords matches
      return redirect()->back()->with("error", "Your current password does not match with the password you provided. Please try again.");
    }
   

    if ((Hash::check($request->get('new_password'), Auth::user()->password))) {
      // The passwords matches
      return redirect()->back()->with("error", "Your current password and new password are same.");
    }

    $validatedData = $request->validate([

      'new_password_confirmation' => 'required|string|same:new_password'
    ]);

    //Change Password
    $user = Auth::user();
    $user->password = bcrypt($request->get('new_password'));
    $user->save();

    return redirect()->back()->with("success", "Password changed successfully !");
  }

  public function changeEmail(Request $request)
  {

    if ($request->isMethod('post')) {
      $validatedData = $request->validate([
        'email' => 'required|email|unique:users,email|max:255',
      ]);
      $user = request()->user();
      $user->update(['email' => $request->email]);
      return redirect()->back()->with('alert-class', 'alert-success')->with('success', 'Email successfully changed.');
    }

    $title =  'Change email';
    $heading =  'Change email';

    return view('auth.change_email', compact('title', 'heading'));
  }

  public function manageProfile(Request $request)
  {
   
      if ($request->isMethod('post')) {

        if ($request->hasFile('logo')) {
          $file_type = $request->file('logo')->extension();
          $file_path = $request->file('logo')->storeAs('images/admins', time() . '.' . $file_type, 'public');
          $request->file('logo')->move(public_path('images/admins'), time() . '.' . $file_type);
        } else {
          $file_path = request()->user()->profile_image;
        }

        if ($request->hasFile('logo_w')) {
          $file_type_l = $request->file('logo_w')->extension();
          $file_path_l = $request->file('logo_w')->storeAs(time() . 'logo.' . $file_type_l, '');
          $request->file('logo_w')->move(public_path('Images/logo'), time() . 'logo.' . $file_type_l);
        } else {
          $file_path_l = getSetting('logo');
        }


        $user = User::find(request()->user()->id);
        //$user->email= $request->email;
        $user->name = $request->name;
        $user->phone = $request->phone;
        $user->address = $request->address;
        $user->profile_image = $file_path;
        $user->country = $request->country_code;
        $user->code = $request->dial_code;
        $user->save();


        DB::table('site_settings')->where('key', 'logo')->update([
          'value' => $file_path_l,
        ]);



        return redirect()->back()->with('alert-class', 'alert-success')->with('success', 'Manage profile successfully changed.');
      }

      $title =  'Manage Profile';
      $heading =  'Manage Profile';

      return view('admin.auth.manage_profile', compact('title', 'heading'));
    }
   
     
  


  function logout()
  {
    Session::flush();
    Auth::guard("siteAdmin")->logout();
    return redirect()->route('admin.login');
  }
}
